/**
 * 
 */
package gui;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

/**
 * @author Andrea
 *
 */
public class TableMenu extends JPopupMenu
{

	/**
	 * 
	 */
	private boolean usingTarget = false;
	private static final long serialVersionUID = 1L;
	private JMenuItem editService;
	private int selected;
	
	public TableMenu()
	{
		super();
		init();
	}
	
	void init()
	{
		this.add(getEditService());
	}
	
	public void setUsingTarget(boolean t)
	{
		usingTarget = t;
	}
	
	public JMenuItem getEditService()
	{
		if(editService == null)
		{
			editService = new JMenuItem();
			editService.setText("Edit in external editor");
			editService.addActionListener(new ActionListener()
			{
				public void actionPerformed(ActionEvent e)
				{
					try
					{
						if(usingTarget)
						{
							File toOpen = new File(GenericLoader.getPathTarget());
							if(Desktop.isDesktopSupported())
							{
								Desktop.getDesktop().open(toOpen);
							}
							else
							{
								throw new Exception("Sorry, your System does not support this functionality.");
							}
						}
						else
						{
							Vector<String> availablePaths = GenericLoader.getPathAvailableService();
							String path = availablePaths.elementAt(selected);
							File toOpen = new File(path);
							
							if(Desktop.isDesktopSupported())
							{
								Desktop.getDesktop().open(toOpen);
							}
							else
							{
								throw new Exception("Sorry, your System does not support this functionality.");
							}
						}
					}
					catch(Exception exc)
					{
						JOptionPane.showMessageDialog(MainFrame.getInstance(), "Error: "+exc.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
					}
				}
			}
			);
		}
		return editService;
	}
	
	public void setSelected(int n)
	{
		selected = n;
	}
}
